<?php
// Inclui o arquivo de conexão com o banco de dados
include 'conexao.php';

// Configuração de CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Define o método HTTP
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $page = isset($_GET['page']) ? intval($_GET['page']) : 1;
    $limit = 12;
    $offset = ($page - 1) * $limit;

    $sql = "SELECT * FROM categorias_transacoes ORDER BY id DESC LIMIT :limit OFFSET :offset";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);

    $stmt->execute();
    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
    exit;
}

if ($method === 'POST') {
    // Recebe os dados enviados no corpo da requisição
    $data = json_decode(file_get_contents("php://input"), true);

// Log para verificar os dados recebidos
file_put_contents("logs/api_debug.log", print_r($data, true), FILE_APPEND);

if (!$data || !isset($data['documento'])) {
    throw new Exception("Erro: Dados inválidos para criação de boleto.");
}

    $sql = "INSERT INTO categorias_transacoes (nome, descricao) VALUES (:nome, :descricao)";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(":nome", $data['nome']);
    $stmt->bindValue(":descricao", $data['descricao'] ?? null);

    $stmt->execute();
    echo json_encode(['message' => 'Categoria cadastrada com sucesso.']);
    exit;
}

if ($method === 'PUT') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];
    unset($data['id']);

    $sql = "UPDATE categorias_transacoes SET nome = :nome, descricao = :descricao WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(":nome", $data['nome']);
    $stmt->bindValue(":descricao", $data['descricao']);
    $stmt->bindValue(':id', $id, PDO::PARAM_INT);

    $stmt->execute();
    echo json_encode(['message' => 'Categoria atualizada com sucesso.']);
    exit;
}

if ($method === 'DELETE') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];

    $sql = "DELETE FROM categorias_transacoes WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    $stmt->execute();
    echo json_encode(['message' => 'Categoria excluída com sucesso.']);
    exit;
}
?>
