<?php
// Inclui o arquivo de conexão com o banco de dados
include 'conexao.php';

// Configuração de CORS - Permite qualquer domínio acessar
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");


// Define o método HTTP
$method = $_SERVER['REQUEST_METHOD'];

// Rota para listar ou visualizar um centro de custo específico
if ($method === 'GET') {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if ($id) {
        // Visualizar um centro de custo específico
        $sql = "SELECT * FROM centro_de_custo WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    } else {
        // Listar todos os centros de custo
        $sql = "SELECT * FROM centro_de_custo";
        $stmt = $pdo->prepare($sql);
    }

    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($result);
    exit;
}

// Rota para adicionar um novo centro de custo
if ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);

    // Verifica se os campos obrigatórios estão preenchidos
    if (empty($data['nome']) || empty($data['empresa_id'])) {
        http_response_code(400);
        echo json_encode(['message' => 'Nome e Empresa ID são obrigatórios.']);
        exit;
    }

    $sql = "INSERT INTO centro_de_custo (nome, descricao, empresa_id) VALUES (:nome, :descricao, :empresa_id)";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':nome', $data['nome']);
    $stmt->bindParam(':descricao', $data['descricao']);
    $stmt->bindParam(':empresa_id', $data['empresa_id'], PDO::PARAM_INT);

    if ($stmt->execute()) {
        echo json_encode(['message' => 'Centro de Custo adicionado com sucesso.']);
    } else {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao adicionar Centro de Custo.']);
    }
    exit;
}

// Rota para atualizar um centro de custo existente
if ($method === 'PUT') {
    $data = json_decode(file_get_contents("php://input"), true);

    // Verifica se o ID está presente
    if (empty($data['id'])) {
        http_response_code(400);
        echo json_encode(['message' => 'ID é obrigatório para atualizar.']);
        exit;
    }

    $sql = "UPDATE centro_de_custo SET nome = :nome, descricao = :descricao, empresa_id = :empresa_id WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':nome', $data['nome']);
    $stmt->bindParam(':descricao', $data['descricao']);
    $stmt->bindParam(':empresa_id', $data['empresa_id'], PDO::PARAM_INT);
    $stmt->bindParam(':id', $data['id'], PDO::PARAM_INT);

    if ($stmt->execute()) {
        echo json_encode(['message' => 'Centro de Custo atualizado com sucesso.']);
    } else {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao atualizar Centro de Custo.']);
    }
    exit;
}

// Rota para deletar um centro de custo
if ($method === 'DELETE') {
    $data = json_decode(file_get_contents("php://input"), true);

    // Verifica se o ID está presente
    if (empty($data['id'])) {
        http_response_code(400);
        echo json_encode(['message' => 'ID é obrigatório para excluir.']);
        exit;
    }

    $sql = "DELETE FROM centro_de_custo WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $data['id'], PDO::PARAM_INT);

    if ($stmt->execute()) {
        echo json_encode(['message' => 'Centro de Custo excluído com sucesso.']);
    } else {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao excluir Centro de Custo.']);
    }
    exit;
}
?>
