<?php
include 'conexao.php';

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $id = isset($_GET['id']) ? $_GET['id'] : null;
    if ($id) {
        $sql = "SELECT * FROM clientes_novo WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    } else {
        $sql = "SELECT * FROM clientes_novo";
        $stmt = $pdo->prepare($sql);
    }
    $stmt->execute();
    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
    exit;
}

if ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);
    $sql = "INSERT INTO clientes_novo (empresa_id, nome_completo, cpf_cnpj, rg_ie, data_nascimento, sexo, indicacao, 
            telefone_fixo, celular, email, website, cep, endereco, numero, complemento, bairro, cidade, estado, status_id) 
            VALUES (:empresa_id, :nome_completo, :cpf_cnpj, :rg_ie, :data_nascimento, :sexo, :indicacao, 
                    :telefone_fixo, :celular, :email, :website, :cep, :endereco, :numero, :complemento, :bairro, :cidade, :estado, :status_id)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($data);
    echo json_encode(['message' => 'Cliente cadastrado com sucesso.']);
    exit;
}

if ($method === 'PUT') {
    $data = json_decode(file_get_contents("php://input"), true);

    // Certifique-se de que todos os parâmetros estão presentes no array $data
    $sql = "UPDATE clientes_novo SET 
            empresa_id = :empresa_id, 
            nome_completo = :nome_completo, 
            cpf_cnpj = :cpf_cnpj, 
            rg_ie = :rg_ie, 
            data_nascimento = :data_nascimento, 
            sexo = :sexo, 
            indicacao = :indicacao, 
            telefone_fixo = :telefone_fixo, 
            celular = :celular, 
            email = :email, 
            website = :website, 
            cep = :cep, 
            endereco = :endereco, 
            numero = :numero, 
            complemento = :complemento, 
            bairro = :bairro, 
            cidade = :cidade, 
            estado = :estado, 
            status_id = :status_id 
            WHERE id = :id";
    
    $stmt = $pdo->prepare($sql);

    // Assegurar que o array tem todos os parâmetros necessários
    $params = [
        ':empresa_id' => $data['empresa_id'] ?? null,
        ':nome_completo' => $data['nome_completo'] ?? null,
        ':cpf_cnpj' => $data['cpf_cnpj'] ?? null,
        ':rg_ie' => $data['rg_ie'] ?? null,
        ':data_nascimento' => $data['data_nascimento'] ?? null,
        ':sexo' => $data['sexo'] ?? null,
        ':indicacao' => $data['indicacao'] ?? null,
        ':telefone_fixo' => $data['telefone_fixo'] ?? null,
        ':celular' => $data['celular'] ?? null,
        ':email' => $data['email'] ?? null,
        ':website' => $data['website'] ?? null,
        ':cep' => $data['cep'] ?? null,
        ':endereco' => $data['endereco'] ?? null,
        ':numero' => $data['numero'] ?? null,
        ':complemento' => $data['complemento'] ?? null,
        ':bairro' => $data['bairro'] ?? null,
        ':cidade' => $data['cidade'] ?? null,
        ':estado' => $data['estado'] ?? null,
        ':status_id' => $data['status_id'] ?? '1',
        ':id' => $data['id']
    ];

    $stmt->execute($params);

    echo json_encode(['message' => 'Cliente atualizado com sucesso.']);
    exit;
}

if ($method === 'DELETE') {
    $data = json_decode(file_get_contents("php://input"), true);
    $sql = "DELETE FROM clientes_novo WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $data['id'], PDO::PARAM_INT);
    $stmt->execute();
    echo json_encode(['message' => 'Cliente excluído com sucesso.']);
    exit;
}
?>
