<?php
require_once 'conexao.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configurações CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");

// Função de log para registrar erros e informações
function logRequisicao($mensagem) {
    file_put_contents('logs_backend.txt', date('Y-m-d H:i:s') . " - " . $mensagem . PHP_EOL, FILE_APPEND);
}

// Validar método OPTIONS (pre-flight request do CORS)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Verificar se a requisição é POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // Verificar se o JSON é válido
    if (json_last_error() !== JSON_ERROR_NONE) {
        $jsonError = json_last_error_msg();
        logRequisicao("Erro no JSON recebido: $jsonError");
        http_response_code(400);
        echo json_encode(['message' => 'Erro no JSON enviado.', 'error' => $jsonError]);
        exit();
    }

    logRequisicao("Dados recebidos: " . print_r($data, true));

    // Verificar se a conexão com o banco está ativa
    try {
        $stmt = $pdo->query("SELECT DATABASE() AS db");
        $result = $stmt->fetch();
        logRequisicao("Conectado ao banco: " . $result['db']);
    } catch (PDOException $e) {
        logRequisicao("Erro ao verificar banco: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao conectar ao banco.', 'error' => $e->getMessage()]);
        exit();
    }

    // Definir e validar campos recebidos
    $empresa_id = isset($data['empresa_id']) ? (int) $data['empresa_id'] : null;
    $data_nascimento = !empty($data['data_nascimento']) ? $data['data_nascimento'] : null;
    $sexo = in_array($data['sexo'], ['Masculino', 'Feminino', 'Outro']) ? $data['sexo'] : null;

    logRequisicao("Dados processados: " . print_r([
        'empresa_id' => $empresa_id,
        'data_nascimento' => $data_nascimento,
        'sexo' => $sexo
    ], true));

    // Query de inserção
    $sql = "INSERT INTO clientes_novo (
                empresa_id, nome_completo, cpf_cnpj, rg_ie, data_nascimento, 
                sexo, indicacao, telefone_fixo, celular, email, website, 
                cep, endereco, numero, complemento, bairro, cidade, estado, 
                status_id, data_criacao
            ) VALUES (
                :empresa_id, :nome_completo, :cpf_cnpj, :rg_ie, :data_nascimento, 
                :sexo, :indicacao, :telefone_fixo, :celular, :email, :website, 
                :cep, :endereco, :numero, :complemento, :bairro, :cidade, :estado, 
                :status_id, NOW()
            )";

    // Logar a query e os parâmetros
    logRequisicao("Preparando query: $sql");
    logRequisicao("Parâmetros: " . print_r([
        ':empresa_id' => $empresa_id,
        ':nome_completo' => tratarCampo($data['nome_completo']),
        ':cpf_cnpj' => tratarCampo($data['cpf_cnpj']),
        ':rg_ie' => tratarCampo($data['rg_ie']),
        ':data_nascimento' => $data_nascimento,
        ':sexo' => $sexo,
        ':indicacao' => tratarCampo($data['indicacao']),
        ':telefone_fixo' => tratarCampo($data['telefone_fixo']),
        ':celular' => tratarCampo($data['celular']),
        ':email' => tratarCampo($data['email']),
        ':website' => tratarCampo($data['website']),
        ':cep' => tratarCampo($data['cep']),
        ':endereco' => tratarCampo($data['endereco']),
        ':numero' => tratarCampo($data['numero']),
        ':complemento' => tratarCampo($data['complemento']),
        ':bairro' => tratarCampo($data['bairro']),
        ':cidade' => tratarCampo($data['cidade']),
        ':estado' => tratarCampo($data['estado']),
        ':status_id' => $data['status_id'] ?? 1,
    ], true));

    // Preparar e executar a query
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':empresa_id' => $empresa_id,
            ':nome_completo' => tratarCampo($data['nome_completo']),
            ':cpf_cnpj' => tratarCampo($data['cpf_cnpj']),
            ':rg_ie' => tratarCampo($data['rg_ie']),
            ':data_nascimento' => $data_nascimento,
            ':sexo' => $sexo,
            ':indicacao' => tratarCampo($data['indicacao']),
            ':telefone_fixo' => tratarCampo($data['telefone_fixo']),
            ':celular' => tratarCampo($data['celular']),
            ':email' => tratarCampo($data['email']),
            ':website' => tratarCampo($data['website']),
            ':cep' => tratarCampo($data['cep']),
            ':endereco' => tratarCampo($data['endereco']),
            ':numero' => tratarCampo($data['numero']),
            ':complemento' => tratarCampo($data['complemento']),
            ':bairro' => tratarCampo($data['bairro']),
            ':cidade' => tratarCampo($data['cidade']),
            ':estado' => tratarCampo($data['estado']),
            ':status_id' => $data['status_id'] ?? 1,
        ]);

        logRequisicao("Cliente cadastrado com sucesso.");
        http_response_code(201); // Código HTTP 201: Recurso criado
        echo json_encode(['message' => 'Cliente cadastrado com sucesso.']);
    } catch (PDOException $e) {
        logRequisicao("Erro na execução da query: " . $e->getMessage());
        http_response_code(400);
        echo json_encode(['message' => 'Erro ao cadastrar cliente.', 'error' => $e->getMessage()]);
    }
} else {
    logRequisicao("Método não permitido: " . $_SERVER['REQUEST_METHOD']);
    http_response_code(405);
    echo json_encode(['message' => 'Método não permitido.']);
}

// Função para tratar campos vazios
function tratarCampo($campo) {
    return isset($campo) && trim($campo) !== '' ? $campo : null;
}
?>
