<?php
include 'conexao.php';

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if ($id) {
        $sql = "SELECT * FROM contas_bancarias WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    } else {
        $sql = "SELECT * FROM contas_bancarias";
        $stmt = $pdo->prepare($sql);
    }

    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($result);
    exit;
}

if ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['banco']) || empty($data['agencia']) || empty($data['conta_corrente']) || empty($data['empresa_id'])) {
        http_response_code(400);
        echo json_encode(['message' => 'Banco, Agência, Conta Corrente e Empresa são obrigatórios.']);
        exit;
    }

    $sql = "INSERT INTO contas_bancarias (banco, agencia, conta_corrente, tipo_conta, descricao, empresa_id) VALUES (:banco, :agencia, :conta_corrente, :tipo_conta, :descricao, :empresa_id)";
    $stmt = $pdo->prepare($sql);

    $stmt->bindValue(':banco', $data['banco']);
    $stmt->bindValue(':agencia', $data['agencia']);
    $stmt->bindValue(':conta_corrente', $data['conta_corrente']);
    $stmt->bindValue(':tipo_conta', $data['tipo_conta']);
    $stmt->bindValue(':descricao', $data['descricao']);
    $stmt->bindValue(':empresa_id', $data['empresa_id'], PDO::PARAM_INT);

    try {
        $stmt->execute();
        echo json_encode(['message' => 'Conta bancária adicionada com sucesso.']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao adicionar conta bancária.', 'error' => $e->getMessage()]);
    }
    exit;
}

if ($method === 'PUT') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];

    $sql = "UPDATE contas_bancarias SET banco = :banco, agencia = :agencia, conta_corrente = :conta_corrente, tipo_conta = :tipo_conta, descricao = :descricao, empresa_id = :empresa_id WHERE id = :id";
    $stmt = $pdo->prepare($sql);

    $stmt->bindValue(':banco', $data['banco']);
    $stmt->bindValue(':agencia', $data['agencia']);
    $stmt->bindValue(':conta_corrente', $data['conta_corrente']);
    $stmt->bindValue(':tipo_conta', $data['tipo_conta']);
    $stmt->bindValue(':descricao', $data['descricao']);
    $stmt->bindValue(':empresa_id', $data['empresa_id'], PDO::PARAM_INT);
    $stmt->bindValue(':id', $id, PDO::PARAM_INT);

    try {
        $stmt->execute();
        echo json_encode(['message' => 'Conta bancária atualizada com sucesso.']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao atualizar conta bancária.', 'error' => $e->getMessage()]);
    }
    exit;
}

if ($method === 'DELETE') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];

    $sql = "DELETE FROM contas_bancarias WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    try {
        $stmt->execute();
        echo json_encode(['message' => 'Conta bancária excluída com sucesso.']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao excluir conta bancária.', 'error' => $e->getMessage()]);
    }
    exit;
}
?>
