<?php
// Inclui o arquivo de conexão com o banco de dados
include 'conexao.php';

// Configuração de CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Define o método HTTP
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if ($id) {
        $sql = "SELECT * FROM fornecedores_novo WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    } else {
        $sql = "SELECT * FROM fornecedores_novo";
        $stmt = $pdo->prepare($sql);
    }

    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($result);
    exit;
}

if ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);

    // Verifica campos obrigatórios
    if (empty($data['cnpj']) || empty($data['nome_razao_social']) || empty($data['empresa_id'])) {
        http_response_code(400);
        echo json_encode(['message' => 'CNPJ, Nome Razão Social e Empresa são obrigatórios.']);
        exit;
    }

    $sql = "INSERT INTO fornecedores_novo (
        nome_razao_social, nome_fantasia, cnpj, inscricao_estadual, data_fundacao, tipo_fornecedor,
        telefone_fixo, celular, email, website, cep, endereco, numero, complemento, bairro, cidade, estado,
        ramo_atividade, banco, agencia, conta_corrente, tipo_conta, nome_representante, cpf_representante,
        telefone_representante, email_representante, empresa_id
    ) VALUES (
        :nome_razao_social, :nome_fantasia, :cnpj, :inscricao_estadual, :data_fundacao, :tipo_fornecedor,
        :telefone_fixo, :celular, :email, :website, :cep, :endereco, :numero, :complemento, :bairro, :cidade, :estado,
        :ramo_atividade, :banco, :agencia, :conta_corrente, :tipo_conta, :nome_representante, :cpf_representante,
        :telefone_representante, :email_representante, :empresa_id
    )";

    $stmt = $pdo->prepare($sql);

    $campos = [
        'nome_razao_social', 'nome_fantasia', 'cnpj', 'inscricao_estadual', 'data_fundacao', 'tipo_fornecedor',
        'telefone_fixo', 'celular', 'email', 'website', 'cep', 'endereco', 'numero', 'complemento', 'bairro',
        'cidade', 'estado', 'ramo_atividade', 'banco', 'agencia', 'conta_corrente', 'tipo_conta',
        'nome_representante', 'cpf_representante', 'telefone_representante', 'email_representante', 'empresa_id'
    ];

    foreach ($campos as $campo) {
        $valor = isset($data[$campo]) && $data[$campo] !== "" ? $data[$campo] : null;
        $stmt->bindValue(":$campo", $valor, is_null($valor) ? PDO::PARAM_NULL : PDO::PARAM_STR);
    }

    try {
        $stmt->execute();
        echo json_encode(['message' => 'Fornecedor cadastrado com sucesso.']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao cadastrar fornecedor.', 'error' => $e->getMessage()]);
    }
    exit;
}

if ($method === 'PUT') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];
    unset($data['id']);
    unset($data['created_at']);

    $sql = "UPDATE fornecedores_novo SET
        nome_razao_social = :nome_razao_social, nome_fantasia = :nome_fantasia, cnpj = :cnpj,
        inscricao_estadual = :inscricao_estadual, data_fundacao = :data_fundacao, tipo_fornecedor = :tipo_fornecedor,
        telefone_fixo = :telefone_fixo, celular = :celular, email = :email, website = :website, cep = :cep,
        endereco = :endereco, numero = :numero, complemento = :complemento, bairro = :bairro, cidade = :cidade,
        estado = :estado, ramo_atividade = :ramo_atividade, banco = :banco, agencia = :agencia,
        conta_corrente = :conta_corrente, tipo_conta = :tipo_conta, nome_representante = :nome_representante,
        cpf_representante = :cpf_representante, telefone_representante = :telefone_representante,
        email_representante = :email_representante, empresa_id = :empresa_id
    WHERE id = :id";

    $stmt = $pdo->prepare($sql);

    foreach ($data as $key => $value) {
        $stmt->bindValue(":$key", $value === "" ? null : $value);
    }
    $stmt->bindValue(':id', $id, PDO::PARAM_INT);

    try {
        $stmt->execute();
        echo json_encode(['message' => 'Fornecedor atualizado com sucesso.']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao atualizar fornecedor.', 'error' => $e->getMessage()]);
    }
    exit;
}

if ($method === 'DELETE') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];

    $sql = "DELETE FROM fornecedores_novo WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    try {
        $stmt->execute();
        echo json_encode(['message' => 'Fornecedor excluído com sucesso.']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao excluir fornecedor.', 'error' => $e->getMessage()]);
    }
    exit;
}
?>
