<?php
// Inclui o arquivo de conexão
include 'conexao.php';

// Configuração de CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Define o método HTTP
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    // Verifica se foi enviado um ID específico para busca
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if ($id) {
        $sql = "SELECT * FROM funcionarios WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    } else {
        $sql = "SELECT * FROM funcionarios";
        $stmt = $pdo->prepare($sql);
    }

    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Retorna a lista ou funcionário específico em JSON
    echo json_encode($result);
    exit;
}

if ($method === 'POST') {
    // Recebe os dados enviados no corpo da requisição
    $data = json_decode(file_get_contents("php://input"), true);

    $sql = "INSERT INTO funcionarios (
        nome_completo, cpf, rg, data_nascimento, sexo, estado_civil, nacionalidade, naturalidade,
        telefone_fixo, celular, email, cep, endereco, numero, complemento, bairro, cidade, estado,
        cargo, departamento, data_admissao, salario, tipo_contrato, carga_horaria_semanal, supervisor_imediato,
        banco, agencia, conta_corrente, tipo_conta, ctps, pis_pasep, certificado_reservista, cnh,
        plano_saude, vale_refeicao, vale_transporte, outros_beneficios, empresa_id, observacoes, outros_documentos
    ) VALUES (
        :nome_completo, :cpf, :rg, :data_nascimento, :sexo, :estado_civil, :nacionalidade, :naturalidade,
        :telefone_fixo, :celular, :email, :cep, :endereco, :numero, :complemento, :bairro, :cidade, :estado,
        :cargo, :departamento, :data_admissao, :salario, :tipo_contrato, :carga_horaria_semanal, :supervisor_imediato,
        :banco, :agencia, :conta_corrente, :tipo_conta, :ctps, :pis_pasep, :certificado_reservista, :cnh,
        :plano_saude, :vale_refeicao, :vale_transporte, :outros_beneficios, :empresa_id, :observacoes, :outros_documentos
    )";

    $stmt = $pdo->prepare($sql);

    // Campos que serão vinculados
    $campos = [
        'nome_completo', 'cpf', 'rg', 'data_nascimento', 'sexo', 'estado_civil', 'nacionalidade', 'naturalidade',
        'telefone_fixo', 'celular', 'email', 'cep', 'endereco', 'numero', 'complemento', 'bairro', 'cidade', 'estado',
        'cargo', 'departamento', 'data_admissao', 'salario', 'tipo_contrato', 'carga_horaria_semanal', 'supervisor_imediato',
        'banco', 'agencia', 'conta_corrente', 'tipo_conta', 'ctps', 'pis_pasep', 'certificado_reservista', 'cnh',
        'plano_saude', 'vale_refeicao', 'vale_transporte', 'outros_beneficios', 'empresa_id', 'observacoes', 'outros_documentos'
    ];

    foreach ($campos as $campo) {
        $valor = isset($data[$campo]) && $data[$campo] !== "" ? $data[$campo] : null;
        $stmt->bindValue(":$campo", $valor, is_null($valor) ? PDO::PARAM_NULL : PDO::PARAM_STR);
    }

    $stmt->execute();
    echo json_encode(['message' => 'Funcionário cadastrado com sucesso.']);
    exit;
}

if ($method === 'PUT') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id']; // ID do funcionário a ser atualizado
    unset($data['id']); // Remove o ID do array para não ser atualizado
    unset($data['data_cadastro']); // Remove data_cadastro, pois não é atualizável

    $sql = "UPDATE funcionarios SET
        nome_completo = :nome_completo, cpf = :cpf, rg = :rg, data_nascimento = :data_nascimento,
        sexo = :sexo, estado_civil = :estado_civil, nacionalidade = :nacionalidade, naturalidade = :naturalidade,
        telefone_fixo = :telefone_fixo, celular = :celular, email = :email, cep = :cep, endereco = :endereco,
        numero = :numero, complemento = :complemento, bairro = :bairro, cidade = :cidade, estado = :estado,
        cargo = :cargo, departamento = :departamento, data_admissao = :data_admissao, salario = :salario,
        tipo_contrato = :tipo_contrato, carga_horaria_semanal = :carga_horaria_semanal, supervisor_imediato = :supervisor_imediato,
        banco = :banco, agencia = :agencia, conta_corrente = :conta_corrente, tipo_conta = :tipo_conta,
        ctps = :ctps, pis_pasep = :pis_pasep, certificado_reservista = :certificado_reservista, cnh = :cnh,
        plano_saude = :plano_saude, vale_refeicao = :vale_refeicao, vale_transporte = :vale_transporte,
        outros_beneficios = :outros_beneficios, empresa_id = :empresa_id, observacoes = :observacoes,
        outros_documentos = :outros_documentos
    WHERE id = :id";

    $stmt = $pdo->prepare($sql);

    foreach ($data as $key => $value) {
        $stmt->bindValue(":$key", $value === "" ? null : $value);
    }
    $stmt->bindValue(':id', $id, PDO::PARAM_INT);

    $stmt->execute();
    echo json_encode(['message' => 'Funcionário atualizado com sucesso.']);
    exit;
}

if ($method === 'DELETE') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];

    $sql = "DELETE FROM funcionarios WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    $stmt->execute();
    echo json_encode(['message' => 'Funcionário excluído com sucesso.']);
    exit;
}
?>
