<?php
require 'conexao.php';
require __DIR__ . '/vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['emailOuLogin']) || !isset($input['senha'])) {
    http_response_code(400);
    echo json_encode(['message' => 'Email/Login e senha são obrigatórios']);
    exit();
}

$emailOuLogin = $input['emailOuLogin'];
$senha = $input['senha'];

try {
    // Consulta preparada para evitar erros de parâmetro
    $stmt = $pdo->prepare("SELECT id, nome, senha, empresa_id FROM usuarios WHERE email = ? OR login = ?");
    $stmt->execute([$emailOuLogin, $emailOuLogin]);  // Passa dois parâmetros na ordem correta
    $user = $stmt->fetch();

    if (!$user || !password_verify($senha, $user['senha'])) {
        http_response_code(401);
        echo json_encode(['message' => 'Usuário ou senha incorretos']);
        exit();
    }

    $jwt_secret = 'seu_jwt_secret';
    $payload = [
        'id' => $user['id'],
        'nome' => $user['nome'],
        'empresa_id' => $user['empresa_id'], // ✅ Agora incluímos o `empresa_id`
        'exp' => time() + (60 * 60)  // Expiração de 1 hora
    ];

    $token = JWT::encode($payload, $jwt_secret, 'HS256');

    echo json_encode(['token' => $token]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Erro ao processar o login: ' . $e->getMessage()]);
    exit();
}
