<?php
// Inclui a conexão com o banco de dados
include 'conexao.php';

// Configuração de CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Define o método HTTP
$method = $_SERVER['REQUEST_METHOD'];

// Função para manipular o método GET
if ($method === 'GET') {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if ($id) {
        $sql = "SELECT * FROM produtos WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    } else {
        $sql = "SELECT * FROM produtos";
        $stmt = $pdo->prepare($sql);
    }

    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($result);
    exit;
}

// Função para manipular o método POST (Adicionar Produto)
if ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);

    if (empty($data['nome_produto']) || empty($data['empresa_id'])) {
        http_response_code(400);
        echo json_encode(['message' => 'Nome do produto e empresa_id são obrigatórios.']);
        exit;
    }

    $sql = "INSERT INTO produtos (
        codigo_produto, nome_produto, descricao_produto, categoria, subcategoria, marca, modelo,
        dimensoes, peso, material, cor, unidade_medida, preco_custo, preco_venda, estoque_minimo,
        estoque_atual, localizacao_estoque, fornecedor_principal, codigo_fornecedor, preco_compra_fornecedor,
        lead_time, imagem_principal, imagens_adicionais, codigo_barras, sku, ncm, observacoes, cfop, cst,
        origem_produto, aliquota_icms, aliquota_ipi, empresa_id
    ) VALUES (
        :codigo_produto, :nome_produto, :descricao_produto, :categoria, :subcategoria, :marca, :modelo,
        :dimensoes, :peso, :material, :cor, :unidade_medida, :preco_custo, :preco_venda, :estoque_minimo,
        :estoque_atual, :localizacao_estoque, :fornecedor_principal, :codigo_fornecedor, :preco_compra_fornecedor,
        :lead_time, :imagem_principal, :imagens_adicionais, :codigo_barras, :sku, :ncm, :observacoes, :cfop, :cst,
        :origem_produto, :aliquota_icms, :aliquota_ipi, :empresa_id
    )";

    $stmt = $pdo->prepare($sql);

    foreach ($data as $key => $value) {
        $stmt->bindValue(":$key", $value === "" ? null : $value);
    }

    try {
        $stmt->execute();
        echo json_encode(['message' => 'Produto cadastrado com sucesso.']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao cadastrar produto.', 'error' => $e->getMessage()]);
    }
    exit;
}

// Função para manipular o método PUT (Editar Produto)
if ($method === 'PUT') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];
    unset($data['id']);
    unset($data['created_at']);

    $sql = "UPDATE produtos SET
        codigo_produto = :codigo_produto, nome_produto = :nome_produto, descricao_produto = :descricao_produto,
        categoria = :categoria, subcategoria = :subcategoria, marca = :marca, modelo = :modelo,
        dimensoes = :dimensoes, peso = :peso, material = :material, cor = :cor, unidade_medida = :unidade_medida,
        preco_custo = :preco_custo, preco_venda = :preco_venda, estoque_minimo = :estoque_minimo,
        estoque_atual = :estoque_atual, localizacao_estoque = :localizacao_estoque, fornecedor_principal = :fornecedor_principal,
        codigo_fornecedor = :codigo_fornecedor, preco_compra_fornecedor = :preco_compra_fornecedor,
        lead_time = :lead_time, imagem_principal = :imagem_principal, imagens_adicionais = :imagens_adicionais,
        codigo_barras = :codigo_barras, sku = :sku, ncm = :ncm, observacoes = :observacoes, cfop = :cfop, cst = :cst,
        origem_produto = :origem_produto, aliquota_icms = :aliquota_icms, aliquota_ipi = :aliquota_ipi, empresa_id = :empresa_id
    WHERE id = :id";

    $stmt = $pdo->prepare($sql);

    foreach ($data as $key => $value) {
        $stmt->bindValue(":$key", $value === "" ? null : $value);
    }
    $stmt->bindValue(':id', $id, PDO::PARAM_INT);

    try {
        $stmt->execute();
        echo json_encode(['message' => 'Produto atualizado com sucesso.']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao atualizar produto.', 'error' => $e->getMessage()]);
    }
    exit;
}

// Função para manipular o método DELETE (Remover Produto)
if ($method === 'DELETE') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];

    $sql = "DELETE FROM produtos WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    try {
        $stmt->execute();
        echo json_encode(['message' => 'Produto excluído com sucesso.']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao excluir produto.', 'error' => $e->getMessage()]);
    }
    exit;
}
?>
