<?php
// Inclui a conexão com o banco de dados
include 'conexao.php';

// Configuração de CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Define o método HTTP
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        // Verificando campos obrigatórios para evitar erros
        if (empty($data['nome_projeto']) || empty($data['empresa_id'])) {
            echo json_encode(['message' => 'Nome do Projeto e Empresa são obrigatórios.']);
            http_response_code(400);
            exit;
        }

        $sql = "INSERT INTO projetos (
            nome_projeto, descricao_projeto, data_inicio, data_termino_estimada,
            status_projeto, gerente_id, clientes_envolvidos, orcamento, tipo_edificacao,
            categoria_projeto, observacoes, empresa_id
        ) VALUES (
            :nome_projeto, :descricao_projeto, :data_inicio, :data_termino_estimada,
            :status_projeto, :gerente_id, :clientes_envolvidos, :orcamento, :tipo_edificacao,
            :categoria_projeto, :observacoes, :empresa_id
        )";

        $stmt = $pdo->prepare($sql);

        // Bind dos parâmetros
        $stmt->bindValue(':nome_projeto', $data['nome_projeto'], PDO::PARAM_STR);
        $stmt->bindValue(':descricao_projeto', $data['descricao_projeto'] ?? null, PDO::PARAM_STR);
        $stmt->bindValue(':data_inicio', $data['data_inicio'] ?? null, PDO::PARAM_STR);
        $stmt->bindValue(':data_termino_estimada', $data['data_termino_estimada'] ?? null, PDO::PARAM_STR);
        $stmt->bindValue(':status_projeto', $data['status_projeto'] ?? 'Em Planejamento', PDO::PARAM_STR);
        $stmt->bindValue(':gerente_id', $data['gerente_id'] ?? null, PDO::PARAM_INT);

        // Transformando array de clientes em string (se houver)
        $clientesEnvolvidos = isset($data['clientes_envolvidos']) && is_array($data['clientes_envolvidos']) 
            ? implode(',', $data['clientes_envolvidos']) 
            : null;
        $stmt->bindValue(':clientes_envolvidos', $clientesEnvolvidos, PDO::PARAM_STR);

        $stmt->bindValue(':orcamento', $data['orcamento'] ?? null, PDO::PARAM_STR);
        $stmt->bindValue(':tipo_edificacao', $data['tipo_edificacao'] ?? null, PDO::PARAM_STR);
        $stmt->bindValue(':categoria_projeto', $data['categoria_projeto'] ?? null, PDO::PARAM_STR);
        $stmt->bindValue(':observacoes', $data['observacoes'] ?? null, PDO::PARAM_STR);
        $stmt->bindValue(':empresa_id', $data['empresa_id'], PDO::PARAM_INT);

        $stmt->execute();
        echo json_encode(['message' => 'Projeto cadastrado com sucesso.']);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao cadastrar projeto.', 'error' => $e->getMessage()]);
    }
    exit;
}

if ($method === 'GET') {
    try {
        $id = $_GET['id'] ?? null;

        if ($id) {
            $sql = "SELECT * FROM projetos WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        } else {
            $sql = "SELECT * FROM projetos";
            $stmt = $pdo->prepare($sql);
        }

        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode($result);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao buscar projetos.', 'error' => $e->getMessage()]);
    }
    exit;
}

if ($method === 'PUT') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);
        $id = $data['id'];

        unset($data['id']); // Remove o ID para não ser atualizado diretamente

        $sql = "UPDATE projetos SET
            nome_projeto = :nome_projeto, descricao_projeto = :descricao_projeto,
            data_inicio = :data_inicio, data_termino_estimada = :data_termino_estimada,
            status_projeto = :status_projeto, gerente_id = :gerente_id,
            clientes_envolvidos = :clientes_envolvidos, orcamento = :orcamento,
            tipo_edificacao = :tipo_edificacao, categoria_projeto = :categoria_projeto,
            observacoes = :observacoes, empresa_id = :empresa_id
        WHERE id = :id";

        $stmt = $pdo->prepare($sql);

        // Bind dos parâmetros para atualização
        foreach ($data as $key => $value) {
            $stmt->bindValue(":$key", $value === "" ? null : $value);
        }
        $stmt->bindValue(':id', $id, PDO::PARAM_INT);

        $stmt->execute();
        echo json_encode(['message' => 'Projeto atualizado com sucesso.']);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao atualizar projeto.', 'error' => $e->getMessage()]);
    }
    exit;
}

if ($method === 'DELETE') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);
        $id = $data['id'];

        $sql = "DELETE FROM projetos WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        $stmt->execute();
        echo json_encode(['message' => 'Projeto excluído com sucesso.']);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['message' => 'Erro ao excluir projeto.', 'error' => $e->getMessage()]);
    }
    exit;
}
?>
