<?php
// Inclui o arquivo de conexão com o banco de dados
include 'conexao.php';

// Configuração de CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Define o método HTTP
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if ($id) {
        // Busca um serviço específico
        $sql = "SELECT * FROM servicos WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    } else {
        // Lista todos os serviços
        $sql = "SELECT * FROM servicos";
        $stmt = $pdo->prepare($sql);
    }

    $stmt->execute();
    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
    exit;
}

if ($method === 'POST') {
    // Recebe os dados enviados no corpo da requisição
    $data = json_decode(file_get_contents("php://input"), true);

    $sql = "INSERT INTO servicos (
        codigo_servico, nome_servico, descricao_servico, categoria, subcategoria, 
        unidade_medida, duracao_estimada, custo_servico, preco_venda, 
        fornecedor_principal, custo_fornecedor, recursos_necessarios, observacoes, 
        status_servico, codigo_servico_fiscal, cst, cfop, aliquota_iss, retencao_tributos
    ) VALUES (
        :codigo_servico, :nome_servico, :descricao_servico, :categoria, :subcategoria, 
        :unidade_medida, :duracao_estimada, :custo_servico, :preco_venda, 
        :fornecedor_principal, :custo_fornecedor, :recursos_necessarios, :observacoes, 
        :status_servico, :codigo_servico_fiscal, :cst, :cfop, :aliquota_iss, :retencao_tributos
    )";

    $stmt = $pdo->prepare($sql);

    foreach ($data as $key => $value) {
        $stmt->bindValue(":$key", $value === "" ? null : $value);
    }

    $stmt->execute();
    echo json_encode(['message' => 'Serviço cadastrado com sucesso.']);
    exit;
}

if ($method === 'PUT') {
    // Recebe os dados enviados no corpo da requisição
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];
    unset($data['id']); // Remove o ID para não ser atualizado

    $sql = "UPDATE servicos SET
        codigo_servico = :codigo_servico, nome_servico = :nome_servico, descricao_servico = :descricao_servico,
        categoria = :categoria, subcategoria = :subcategoria, unidade_medida = :unidade_medida,
        duracao_estimada = :duracao_estimada, custo_servico = :custo_servico, preco_venda = :preco_venda,
        fornecedor_principal = :fornecedor_principal, custo_fornecedor = :custo_fornecedor,
        recursos_necessarios = :recursos_necessarios, observacoes = :observacoes,
        status_servico = :status_servico, codigo_servico_fiscal = :codigo_servico_fiscal,
        cst = :cst, cfop = :cfop, aliquota_iss = :aliquota_iss, retencao_tributos = :retencao_tributos
    WHERE id = :id";

    $stmt = $pdo->prepare($sql);

    foreach ($data as $key => $value) {
        $stmt->bindValue(":$key", $value === "" ? null : $value);
    }
    $stmt->bindValue(':id', $id, PDO::PARAM_INT);

    $stmt->execute();
    echo json_encode(['message' => 'Serviço atualizado com sucesso.']);
    exit;
}

if ($method === 'DELETE') {
    // Recebe o ID do serviço a ser excluído
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];

    $sql = "DELETE FROM servicos WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    $stmt->execute();
    echo json_encode(['message' => 'Serviço excluído com sucesso.']);
    exit;
}
?>
