<?php
// Importar a conexão com o banco de dados
include 'conexao.php';

// Configurar CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Verificar o método da requisição
if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    // Obter o ID do cliente da requisição
    $data = json_decode(file_get_contents("php://input"), true);
    $id = isset($data['id']) ? $data['id'] : null;

    // Log do ID recebido
    error_log("ID recebido para exclusão: " . $id); // Log do ID no servidor

    if ($id === null) {
        echo json_encode(['message' => 'ID do cliente não fornecido.']);
        exit;
    }

    // Preparar e executar a exclusão
    $sql = "DELETE FROM clientes_novo WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    if ($stmt->execute()) {
        echo json_encode(['message' => 'Cliente excluído com sucesso.']);
    } else {
        echo json_encode(['message' => 'Erro ao excluir cliente.']);
    }
    exit; // Finaliza a execução após a exclusão
}

// Inicializar um array para armazenar os resultados
$resultados = [];

// Consultar a tabela clientes_novo
$sql = "SELECT * FROM clientes_novo";
$stmt = $pdo->prepare($sql);
$stmt->execute();

// Verificar se há resultados e adicioná-los ao array
if ($stmt->rowCount() > 0) {
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Retornar os resultados como JSON
echo json_encode($resultados);
?>
