<?php
require '../conexao.php';
require '../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

// Configuração de CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$jwt_secret = 'seu_jwt_secret';

$data = json_decode(file_get_contents('php://input'), true);
$email = $data['email'] ?? '';

if (!$email) {
    http_response_code(400);
    echo json_encode(['message' => 'E-mail ou nome de usuário não fornecido.']);
    exit();
}

try {
    $stmt = $pdo->prepare("SELECT id, nome, email FROM usuarios WHERE email = :email");
    $stmt->execute(['email' => $email]);
    $user = $stmt->fetch();

    if (!$user) {
        http_response_code(404);
        echo json_encode(['message' => 'Usuário não encontrado.']);
        exit();
    }

    // Gera o token JWT para o link de redefinição de senha
    $payload = ['id' => $user['id'], 'email' => $user['email']];
    $resetToken = JWT::encode($payload, $jwt_secret, 'HS256');

    $resetLink = "https://sistema.aabbengenharia.com.br/trocar-senha?token=$resetToken";

    // Configurações de SMTP
    $smtpHost = 'mail.aabbengenharia.com.br';
    $smtpPort = 465;
    $smtpUser = 'erp@aabbengenharia.com.br';
    $smtpPass = 'YtWmgSUpkN14'; // Substitua pela senha real do e-mail

    // Conteúdo do e-mail
    $subject = "Redefinição de Senha - Sistema Athix";
    $message = "
        <html>
        <head>
            <title>Redefinição de Senha</title>
        </head>
        <body style='font-family: Arial, sans-serif; text-align: center;'>
            <img src='https://aabbengenharia.com.br/wp-content/uploads/2022/09/thumb.png' alt='Logo' style='width: 150px; margin-bottom: 20px;'>
            <h2>Olá, {$user['nome']}</h2>
            <p>Você solicitou a redefinição da sua senha.</p>
            <p>Clique no botão abaixo para redefinir sua senha:</p>
            <a href='{$resetLink}' 
                style='display: inline-block; padding: 10px 20px; font-size: 16px; color: white; background-color: #2c3e50; text-decoration: none; border-radius: 5px;'>
                Redefinir Senha
            </a>
            <p style='margin-top: 20px;'>Ou copie o link abaixo no seu navegador:</p>
            <p>{$resetLink}</p>
        </body>
        </html>
    ";

    // Envia o e-mail usando a função nativa do PHP com SMTP
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: AABB Erp - Recuperação de senha <{$smtpUser}>" . "\r\n";

    $contextOptions = [
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false,
        ],
    ];

    $socket = fsockopen("ssl://$smtpHost", $smtpPort, $errno, $errstr, 10);
    if (!$socket) {
        http_response_code(500);
        echo json_encode(['message' => "Erro ao conectar ao servidor SMTP: $errstr ($errno)"]);
        exit();
    }

    $read = function ($socket) {
        $data = '';
        while ($str = fgets($socket, 512)) {
            $data .= $str;
            if (strpos($str, "\r\n") !== false) {
                break;
            }
        }
        return $data;
    };

    $write = function ($socket, $cmd) {
        fputs($socket, $cmd . "\r\n");
        return fgets($socket, 512);
    };

    $read($socket);
    $write($socket, "EHLO localhost");
    $write($socket, "AUTH LOGIN");
    $write($socket, base64_encode($smtpUser));
    $write($socket, base64_encode($smtpPass));
    $write($socket, "MAIL FROM:<$smtpUser>");
    $write($socket, "RCPT TO:<{$user['email']}>");
    $write($socket, "DATA");
    $write($socket, "Subject: $subject\r\n$headers\r\n$message\r\n.");
    $write($socket, "QUIT");

    fclose($socket);

    echo json_encode(['message' => 'E-mail enviado com sucesso.']);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Erro ao processar o pedido.']);
    exit();
}
?>
