<?php
require '../conexao.php'; // Inclui a conexão ao banco de dados
require '../vendor/autoload.php'; // Carrega a biblioteca JWT

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

// Configuração de CORS para permitir acesso de qualquer domínio
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$jwt_secret = 'seu_jwt_secret'; // A mesma chave secreta usada no login

// Verifica o token JWT no cabeçalho da requisição
$authHeader = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    $jwt = $matches[1];
} else {
    http_response_code(401);
    echo json_encode(['message' => 'Token não fornecido']);
    exit();
}

try {
    // Decodifica o token JWT
    $decoded = JWT::decode($jwt, new Key($jwt_secret, 'HS256'));
    $userId = $decoded->id;

    // Busca as informações do usuário no banco de dados
    $stmt = $pdo->prepare("SELECT nome, email, empresa_id, perfil_id FROM usuarios WHERE id = :id");
    $stmt->execute(['id' => $userId]);
    $user = $stmt->fetch();

    if (!$user) {
        http_response_code(404);
        echo json_encode(['message' => 'Usuário não encontrado']);
        exit();
    }

    // Retorna os dados do usuário em JSON
    echo json_encode([
        'nome' => $user['nome'],
        'email' => $user['email'],
        'empresa_id' => $user['empresa_id'],
        'perfil_id' => $user['perfil_id'], // Inclui o perfil_id na resposta
    ]);

} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['message' => 'Token inválido ou expirado']);
    exit();
}
?>
