<?php
require '../conexao.php';
require '../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$jwt_secret = 'seu_jwt_secret';

$authHeader = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    $jwt = $matches[1];
} else {
    http_response_code(401);
    echo json_encode(['message' => 'Token não fornecido']);
    exit();
}

try {
    $decoded = JWT::decode($jwt, new Key($jwt_secret, 'HS256'));
    $userId = $decoded->id;

    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
        $stmt = $pdo->prepare("SELECT nome, email, login, DATE_FORMAT(data_criacao, '%d/%m/%Y %H:%i:%s') as data_criacao FROM usuarios WHERE id = :id");
        $stmt->execute(['id' => $userId]);
        $user = $stmt->fetch();

        if (!$user) {
            http_response_code(404);
            echo json_encode(['message' => 'Usuário não encontrado']);
            exit();
        }

        echo json_encode($user);
    } elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $data = json_decode(file_get_contents('php://input'), true);
        $novaSenha = $data['novaSenha'] ?? '';

        if (!$novaSenha) {
            http_response_code(400);
            echo json_encode(['message' => 'Nova senha não fornecida']);
            exit();
        }

        $senhaHash = password_hash($novaSenha, PASSWORD_BCRYPT);
        $stmt = $pdo->prepare("UPDATE usuarios SET senha = :senha WHERE id = :id");
        $stmt->execute(['senha' => $senhaHash, 'id' => $userId]);

        echo json_encode(['message' => 'Senha atualizada com sucesso']);
    } else {
        http_response_code(405);
        echo json_encode(['message' => 'Método não permitido']);
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['message' => 'Token inválido ou expirado']);
    exit();
}
?>
