<?php
require '../conexao.php';
require '../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$jwt_secret = 'seu_jwt_secret';

$data = json_decode(file_get_contents('php://input'), true);
$token = $data['token'] ?? '';
$newPassword = $data['newPassword'] ?? '';

if (!$token || !$newPassword) {
    http_response_code(400);
    echo json_encode(['message' => 'Token ou nova senha não fornecida.']);
    exit();
}

try {
    $decoded = JWT::decode($token, new Key($jwt_secret, 'HS256'));
    $userId = $decoded->id;

    $hashedPassword = password_hash($newPassword, PASSWORD_BCRYPT);
    $stmt = $pdo->prepare("UPDATE usuarios SET senha = :senha WHERE id = :id");
    $stmt->execute(['senha' => $hashedPassword, 'id' => $userId]);

    echo json_encode(['message' => 'Senha atualizada com sucesso.']);
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['message' => 'Token inválido ou expirado.']);
    exit();
}
?>
