<?php
require '../conexao.php';
require '../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

// Configuração de CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

switch ($_SERVER['REQUEST_METHOD']) {
    case 'GET':
        if (isset($_GET['empresas'])) {
            // Listar empresas para o frontend
            $stmt = $pdo->query("SELECT id, nome FROM empresas WHERE status_id = 1");
            $empresas = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($empresas);
            exit();
        }

        // Listar usuários
        $stmt = $pdo->query("
            SELECT u.*, e.nome AS empresa_nome
            FROM usuarios u
            LEFT JOIN empresas e ON u.empresa_id = e.id
        ");
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode($users);
        break;

    case 'POST':
        // Adicionar novo usuário
        $nome = $data['nome'] ?? '';
        $email = $data['email'] ?? '';
        $login = $data['login'] ?? '';
        $senha = $data['senha'] ?? '';
        $perfil_id = $data['perfil_id'] ?? 0;
        $empresa_id = $data['empresa_id'] ?? null;

        // Validação de campos obrigatórios
        if (!$nome || !$email || !$login || !$senha || !$perfil_id) {
            http_response_code(400);
            echo json_encode(['message' => 'Todos os campos obrigatórios devem ser preenchidos.']);
            exit();
        }

        // Valida se empresa_id existe
        if ($empresa_id !== null) {
            $stmt = $pdo->prepare("SELECT id FROM empresas WHERE id = :empresa_id");
            $stmt->execute(['empresa_id' => $empresa_id]);
            if ($stmt->rowCount() === 0) {
                http_response_code(400);
                echo json_encode(['message' => 'ID de empresa inválido.']);
                exit();
            }
        }

        $senhaHash = password_hash($senha, PASSWORD_BCRYPT);
        $stmt = $pdo->prepare("
            INSERT INTO usuarios (nome, email, login, senha, perfil_id, empresa_id)
            VALUES (:nome, :email, :login, :senha, :perfil_id, :empresa_id)
        ");
        $stmt->execute([
            'nome' => $nome,
            'email' => $email,
            'login' => $login,
            'senha' => $senhaHash,
            'perfil_id' => $perfil_id,
            'empresa_id' => $empresa_id,
        ]);
        echo json_encode(['message' => 'Usuário adicionado com sucesso.']);
        break;

    case 'PUT':
        // Editar usuário
        $id = $data['id'] ?? 0;
        $nome = $data['nome'] ?? '';
        $email = $data['email'] ?? '';
        $login = $data['login'] ?? '';
        $perfil_id = $data['perfil_id'] ?? 0;
        $empresa_id = $data['empresa_id'] ?? null;

        if (!$id || !$nome || !$email || !$login || !$perfil_id) {
            http_response_code(400);
            echo json_encode(['message' => 'Todos os campos obrigatórios devem ser preenchidos.']);
            exit();
        }

        if ($empresa_id !== null) {
            $stmt = $pdo->prepare("SELECT id FROM empresas WHERE id = :empresa_id");
            $stmt->execute(['empresa_id' => $empresa_id]);
            if ($stmt->rowCount() === 0) {
                http_response_code(400);
                echo json_encode(['message' => 'ID de empresa inválido.']);
                exit();
            }
        }

        $stmt = $pdo->prepare("
            UPDATE usuarios
            SET nome = :nome, email = :email, login = :login, perfil_id = :perfil_id, empresa_id = :empresa_id
            WHERE id = :id
        ");
        $stmt->execute([
            'id' => $id,
            'nome' => $nome,
            'email' => $email,
            'login' => $login,
            'perfil_id' => $perfil_id,
            'empresa_id' => $empresa_id,
        ]);
        echo json_encode(['message' => 'Usuário atualizado com sucesso.']);
        break;

    case 'DELETE':
        // Remover usuário
        $id = $data['id'] ?? 0;

        if (!$id) {
            http_response_code(400);
            echo json_encode(['message' => 'ID do usuário não fornecido.']);
            exit();
        }

        $stmt = $pdo->prepare("DELETE FROM usuarios WHERE id = :id");
        $stmt->execute(['id' => $id]);
        echo json_encode(['message' => 'Usuário removido com sucesso.']);
        break;

    default:
        http_response_code(405);
        echo json_encode(['message' => 'Método não permitido.']);
        break;
}
?>
